package cs2110;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EnrollmentIndexDemo {
    public static void main(String[] args) {
        Map<Course, List<Student>> rosters = new LinkedHashMap<>();

        Student[] students = new Student[10];
        for (int i=0; i<10; i++) {
            students[i] = new Student("s"+i);
        }

        rosters.put(new Course("cs1110"), List.of(
                students[5], students[6], students[7]
        ));
        rosters.put(new Course("cs2110"), List.of(
            students[0], students[1], students[2], students[3], students[4]
        ));
        rosters.put(new Course("cs3110"), List.of(
            students[8], students[9]
        ));
        rosters.put(new Course("cs2800"), List.of(
            students[1], students[2], students[5], students[6], students[8], students[9]
        ));
        rosters.put(new Course("math1910"), List.of(
            students[0], students[2]
        ));
        rosters.put(new Course("math1920"), List.of(
            students[1], students[4], students[6]
        ));
        rosters.put(new Course("math2930"), List.of(
            students[3], students[5], students[7], students[9]
        ));
        rosters.put(new Course("math2930"), List.of(
            students[7], students[8]
        ));

        EnrollmentIndex index = new EnrollmentIndex(rosters);

        System.out.println("Course Rosters:");
        for(Course c : rosters.keySet()) {
            System.out.print("\t" + c + ": ");
            Iterator<Student> it = rosters.get(c).iterator();
            while (it.hasNext ()) {
                System.out.print(it.next());
                if (it.hasNext()) {
                    System.out.print(", ");
                }
            }
            System.out.println();
        }

        System.out.println("Class Schedules:");
        for(Student s : students) {
            System.out.print("\t" + s + ": ");
            Iterator<Course> it = index.coursesOf(s);
            while (it.hasNext ()) {
                System.out.print(it.next());
                if (it.hasNext()) {
                    System.out.print(", ");
                }
            }
            System.out.println();
        }
    }
}
