package cs2110;

import java.util.*;

public final class EnrollmentIndex {

    /** The "forward" map associating each course to its list of enrolled students.
     *  The list of students in each entry should contain no duplicates and no null entries and
     *  should be ordered in the iterated order of `studentsToCourses.keySet()`. */
    private final Map<Course, List<Student>> coursesToStudents;

    /** The "reverse" map associating each student to the courses in which they are enrolled
     * students. The list of courses in each entry should contain no duplicates and no null
     * entries and should be ordered in the iterated order of `coursesToStudents.keySet()`.*/
    private final Map<Student, List<Course>> studentsToCourses;
    // Use LinkedHashMap/List to preserve first-seen order

    /**
     * Constructs the forward and reverse enrollment indices based on the given `rosters` that
     * associating each course with its list of enrolled students (possibly containing duplicate
     * and/or null values).
     */
    public EnrollmentIndex(Map<Course, List<Student>> rosters){
        coursesToStudents = new LinkedHashMap<>();
        studentsToCourses = new LinkedHashMap<>();

           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: constructor");
    }

    /** Returns whether the given student `s` is enrolled in the given course `c`. */
    public boolean isEnrolled(Student s, Course c){
           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: isEnrolled()");
    }

    /** Returns the number of courses in which `s` is enrolled. */
    public int courseCountOf(Student s){
           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: courseCountOf()");
    }

    /** Returns the number of students enrolled in course `c`. */
    public int enrollmentOf(Course c){
           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: enrollmentOf()");
    }

    /** Returns an iterator over all the students who are enrolled in at least one course, in the
     * order that they first appeared in the rosters. */
    public Iterator<Student> students() {
           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: students()");
    }

    /** Returns an iterator over all the courses in which `s` is enrolled, listed in the order that
     * they appeared in the rosters. */
    public Iterator<Course> coursesOf(Student s){
           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: coursesOf()");
    }

    /** Returns an iterator over all the students who are enrolled in the given course `c`. Each
     * student should be yielded at most once, and no null entries should be returned. */
    public Iterator<Student> studentsIn(Course c){
           // TODO: Implement this method according to its specification.
           throw new UnsupportedOperationException("TODO: studentsIn()");
    }
}
