package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import java.util.*;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

class EnrollmentIndexTest {

    private static Course c(String code) { return new Course(code); }
    private static Student s(String id) { return new Student(id); }
    private static <K,V> LinkedHashMap<K,V> lhm() { return new LinkedHashMap<>(); }

    private static Map<Course, List<Student>> forward() {
        Map<Course, List<Student>> m = lhm();
        Course cs1110 = c("CS 1110");
        Course cs2110 = c("CS 2110");
        Course cs2800 = c("CS 2800");
        Course cs5154 = c("CS 5154");
        m.put(cs1110, Arrays.asList(s("s1111"), s("s1234"), s("s9001")));
        m.put(cs2110, Arrays.asList(s("s1234"), s("s9001"), s("s1111"), s("s9001"), s("s2222")));
        m.put(cs2800, Arrays.asList(s("s7777"), s("s1111"), null, s("s1234")));
        m.put(cs5154, Arrays.asList(s("s9001"), s("s2222"), s("s7777")));
        return m;
    }

    @DisplayName("When we construct an `EnrollmentIndex` from a rosters map, THEN it correctly "
            + "answers queries about student enrollment.")
    @Test
    void build_and_queries_match_spec() {
        EnrollmentIndex idx = new EnrollmentIndex(forward());

        Course cs1110 = c("CS 1110");
        Course cs2110 = c("CS 2110");
        Course cs2800 = c("CS 2800");
        Course cs5154 = c("CS 5154");
        Course nope   = c("NOPE 9999");

        Student s1111 = s("s1111");
        Student s1234 = s("s1234");
        Student s9001 = s("s9001");
        Student s2222 = s("s2222");
        Student s7777 = s("s7777");
        Student s0000 = s("s0000");

        assertTrue(idx.isEnrolled(s1111, cs1110));
        assertTrue(idx.isEnrolled(s1111, cs2110));
        assertFalse(idx.isEnrolled(s1111, cs5154));
        assertFalse(idx.isEnrolled(s0000, cs1110));
        assertFalse(idx.isEnrolled(s1111, nope));

        assertEquals(3, idx.courseCountOf(s1111));
        assertEquals(3, idx.courseCountOf(s1234));
        assertEquals(3, idx.courseCountOf(s9001));
        assertEquals(2, idx.courseCountOf(s2222));
        assertEquals(2, idx.courseCountOf(s7777));
        assertEquals(0, idx.courseCountOf(s0000));

        assertEquals(3, idx.enrollmentOf(cs1110));
        assertEquals(4, idx.enrollmentOf(cs2110));
        assertEquals(3, idx.enrollmentOf(cs2800));
        assertEquals(3, idx.enrollmentOf(cs5154));
        assertEquals(0, idx.enrollmentOf(nope));
    }

    @DisplayName("The iterators returned by an EnrollmentIndex yield their elements in the "
            + "correct orders.")
    @Test
    void iterator_orders_and_empty_cases() {
        EnrollmentIndex idx = new EnrollmentIndex(forward());

        List<Student> studentsSeen = new ArrayList<>();
        idx.students().forEachRemaining(studentsSeen::add);
        assertEquals(Arrays.asList(s("s1111"), s("s1234"), s("s9001"), s("s2222"), s("s7777")), studentsSeen);

        List<Course> sched1111 = new ArrayList<>();
        idx.coursesOf(s("s1111")).forEachRemaining(sched1111::add);
        assertEquals(Arrays.asList(c("CS 1110"), c("CS 2110"), c("CS 2800")), sched1111);

        List<Student> in2110 = new ArrayList<>();
        idx.studentsIn(c("CS 2110")).forEachRemaining(in2110::add);
        assertEquals(Arrays.asList(s("s1234"), s("s9001"), s("s1111"), s("s2222")), in2110);

        assertFalse(idx.coursesOf(s("s0000")).hasNext());
        assertFalse(idx.studentsIn(c("NOPE 9999")).hasNext());
    }
}
