package cs2110;

import java.util.ArrayList;
import java.util.List;

/**
 * A buffer of values of type T with a fixed capacity. This class is thread-safe.
 */
public class ConcurrentRingBuffer<T> {

    /**
     * Backing array storing the values; length is buffer capacity. Elements that do not correspond
     * to contained values are null. Contents guarded by: this
     */
    private final T[] store;

    /**
     * Index of next value that will be returned by `dequeue()`. Must have `0 <= iHead < *
     * store.length`. Guarded by: this
     */
    private int iHead;

    /**
     * Index of next element that can be written to by `enqueue()`. Must have `0 <= iTail < * *
     * store.length`. Guarded by: this
     */
    private int iTail;

    /**
     * Number of values currently contained in buffer. Guarded by: this
     */
    private int size;

    private synchronized void assertInv() {
        assert iHead >= 0;
        assert iHead < store.length;
        assert iTail >= 0;
        assert iTail < store.length;

        for (int i = iTail; i < store.length && i < iHead; i++) {
            assert store[i] == null;
        }
        if (iHead < iTail) {
            for (int i = 0; i < iHead; i++) {
                assert store[i] == null;
            }
        }
    }

    /**
     * Create a new buffer with the specified capacity.
     */
    @SuppressWarnings("unchecked")
    public ConcurrentRingBuffer(int capacity) {
        store = (T[]) new Object[capacity];
        iHead = 0;
        iTail = 0;
        size = 0;
        assertInv();
    }

    /**
     * Returns true if no element can currently be added to the buffer.
     */
    public synchronized boolean isFull() {
        return size == store.length;
    }

    /**
     * Returns true if no element can be consumed from the buffer.
     */
    public synchronized boolean isEmpty() {
        return size == 0;
    }

    /**
     * Append a value `x` to the buffer. Blocks until value is added.
     */
    public synchronized void enqueue(T x) throws InterruptedException {
        // TODO 1: Implement this method according to its specifications.
    }

    /**
     * Remove and return the oldest value in the buffer. Blocks until value is returned.
     */
    public synchronized T dequeue() throws InterruptedException {
        // TODO 2: Implement this method according to its specifications.
        throw new UnsupportedOperationException();
    }

    /**
     * Attempt to share bounded buffer with producer and consumer threads. Blocking is encapsulated
     * in the buffer's operations.
     */
    public static void main(String[] args) {
        // The shared buffer
        ConcurrentRingBuffer<Integer> b = new ConcurrentRingBuffer<Integer>(5);

        List<Thread> threads = new ArrayList<>();
        int np = 3;  // Number of producer threads
        int nc = 3;  // Number of consumer threads

        // Create and start producer threads
        for (int pid = 0; pid < np; ++pid) {
            final int producerId = pid;
            // Task for producer threads to perform
            Runnable p = () -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        int val = producerId * 100 + i;
                        synchronized(b) {
                            b.enqueue(val);
                            System.out.println("Enqueued: " + val);
                        }
                    }
                    System.out.println("Producer " + producerId + " done");
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            };

            Thread t = new Thread(p);
            threads.add(t);
            t.start();
        }

        // Create and start consumer threads
        for (int cid = 0; cid < nc; ++cid) {
            final int consumerId = cid;
            // Task for consumer threads to perform
            Runnable c = () -> {
                try {
                    for (int i = 0; i < 10; ++i) {
                        synchronized(b) {
                            int val = b.dequeue();
                            System.out.println("Dequeued: " + val);
                        }
                    }
                    System.out.println("Consumer " + consumerId + " done");
                } catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            };

            Thread t = new Thread(c);
            threads.add(t);
            t.start();
        }

        // Wait for all threads
        for (Thread t : threads) {
            try {
                t.join();
            } catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }

        System.out.println("Main done");
    }
}
