package cs2110;

import java.util.Iterator;

@FunctionalInterface
interface Combiner<T> { T combine(T x, T y); }

public class CombinerDemo {

    static <T> CS2110List<T> squish(CS2110List<T> list,  Combiner<T> f) {
        CS2110List<T> out = new SinglyLinkedList<>();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T temp = it.next();
            if (it.hasNext()) { out.add(f.combine(temp, it.next())); }
        }
        return out;
    }

    public static void main(String[] args) {
        CS2110List<Integer> list = new SinglyLinkedList<>();
        list.add(1);
        list.add(2);
        list.add(3);
        list.add(4);
        list.add(5);
        list.add(6);
        list.add(7);

        System.out.println(squish(list, (x,y) -> x*y));
    }

}
