package cs2110;

/**
 * An implementation of the Queue ADT using a dynamic array to model a circular buffer.
 */
public class DynamicArrayQueue<T> implements Queue<T> {

    /**
     * The backing storage of this queue. `buffer[front..back) != null` and `buffer[back..front) ==
     * null`, where this interval is circular, so will loop from index `length-1` back to index `0`
     * when appropriate. Must dynamically resize to ensure that at least one index (`back`) is
     * `null`.
     */
    private T[] buffer;

    /**
     * The index of the next element to be `dequeue()`d; equal to `back` if the queue is empty.
     */
    private int front;

    /**
     * The index where the next element will be `enqueue()`d.
     */
    private int back;

    /**
     * The initial capacity for the backing storage array.
     */
    protected static final int INITIAL_CAPACITY = 10;

    public DynamicArrayQueue() {
        buffer = (T[]) new Object[INITIAL_CAPACITY];
        front = 0;
        back = 0;
    }

    @Override
    public void enqueue(T elem) {
        buffer[back] = elem;
        back = (back + 1) % buffer.length;
        if (back == front) { // buffer is full
            T[] bigger = (T[]) new Object[buffer.length * 2];
            System.arraycopy(buffer, front, bigger, 0, buffer.length - front);
            System.arraycopy(buffer, 0, bigger, buffer.length - front, front);
            front = 0;
            back = buffer.length;
            buffer = bigger;
        }
    }

    @Override
    public T dequeue() {
        assert !isEmpty();
        T removed = buffer[front];
        buffer[front] = null;
        front = (front + 1) % buffer.length;
        return removed;
    }

    @Override
    public T peek() {
        assert !isEmpty();
        return buffer[front];
    }

    @Override
    public boolean isEmpty() {
        return front == back;
    }
}
