package cs2110;

/**
 * An immutable class representing a point in the 2D coordinate plane with `double` coordinates.
 */
public record Point(double x, double y) implements Comparable<Point> {
    @Override
    public String toString() {
        return "Point (" + this.x + "," + this.y + ")";
    }

    /**
     * Returns the distance between this point and the given `other` point.
     */
    public double distanceTo(Point other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2) + Math.pow(this.y - other.y, 2));
    }

    /**
     * Reflects this point over the line y = `m`x + `b` for the given slope `m` and y-intercept
     * `b`.
     */
    public Point reflectOver(double m, double b) {
        double newx = this.x - 2 * b * m + 2 * m * this.y - this.x * m * m;
        double newy = 2 * this.x * m + 2 * b + m * m * this.y - this.y;
        double d = 1 + m * m;
        return new Point(newx / d, newy / d);
    }

    /**
     * Compares `this` and `other` based on their distance from the origin, returning
     * a positive integer when `this` is farther from the origin, a negative integer
     * when `this` is closer to the origin, and 0 when `this` and `other` are
     * equidistant from the origin.
     */
    @Override
    public int compareTo(Point other) {
        double thisDistSquared = this.x * this.x + this.y * this.y;
        double otherDistSquared = other.x * other.x + other.y * other.y;
        return (int) Math.signum(thisDistSquared - otherDistSquared);
    }
}
