package cs2110;

import java.util.Comparator;

/**
 * A `Comparator` that models a lexicographic ordering of `Point`s.
 */
public class PointLex implements Comparator<Point> {

    /**
     * Compares `o1` and `o2` lexicographically, returning a negative integer when `o1` is
     * lexicographically earlier, a positive integer when `o2` is lexicographically earlier,
     * and 0 when `o1` and `o2` are equal.
     */
    @Override
    public int compare(Point o1, Point o2) {
        int dx = (int) Math.signum(o1.x() - o2.x());
        return dx == 0 ? (int) Math.signum(o1.y() - o2.y()) : dx;
    }
}
