package cs2110;

/**
 * A priority queue implementation using composition with a max heap.
 */
public class MaxHeapPriorityQueue<T> implements PriorityQueue<T> {

    /**
     * Represents an association of a `priority` to an `elem`. `Entry`s are compared using their
     * priorities.
     */
    private record Entry<T>(T elem, double priority) implements Comparable<Entry<T>> {

        @Override
        public int compareTo(Entry<T> other) {
            return (int) Math.signum(priority - other.priority);
        }
    }

    /**
     * The max heap backing this queue.
     */
    private final MaxHeap<Entry<T>> heap;

    /**
     * Constructs an empty priority queue.
     */
    public MaxHeapPriorityQueue() {
        heap = new MaxHeap<Entry<T>>();
    }

    @Override
    public void add(T elem, double priority) {
        heap.add(new Entry<>(elem, priority));
    }

    @Override
    public boolean isEmpty() {
        return heap.size() == 0;
    }

    @Override
    public T peek() {
        assert !isEmpty();
        return heap.peek().elem;
    }

    @Override
    public T remove() {
        assert !isEmpty();
        return heap.remove().elem;
    }
}
