package cs2110;

import java.util.ArrayList;

/**
 * An implementation of the Map interface leveraging composition with an ArrayList.
 */
public class ListMap<K, V> implements Map<K, V> {

    /**
     * Represents a (key,value) pair in this map
     */
    private record Entry<K, V> (K key, V value) { }

    /**
     * The ArrayList containing the entries of this map.
     */
    private final ArrayList<Entry<K, V>> list;

    /**
     * Constructs a ListMap with no elements.
     */
    public ListMap() {
        list = new ArrayList<>();
    }

    /**
     * Returns the index of the Entry with the given `key` in this map,
     * or -1 if there is no such entry. Requires that `key != null`.
     */
    private int find(K key) {
        assert key != null;
        // linear search:
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).key.equals(key)) {
                return i;
            }
        }
        return -1;
    }

    @Override
    public void put(K key, V value) {
        int i = find(key);
        if (i == -1) { // entry absent, add
            list.add(new Entry<>(key, value));
        } else { // entry present, update
            list.set(i, new Entry<>(key, value));
        }
    }

    @Override
    public boolean containsKey(K key) {
        return find(key) >= 0;
    }

    @Override
    public V get(K key) {
        int i = find(key);
        assert i != -1;
        return list.get(i).value;
    }

    @Override
    public int size() {
        return list.size();
    }

    @Override
    public V remove(K key) {
        int i = find(key);
        assert i != -1;
        return list.remove(i).value;
    }

    @Override
    public Set<K> keySet() {
        Set<K> keys = new ListSet<>();
        for (Entry<K, V> entry : list) {
            keys.add(entry.key);
        }
        return keys;
    }
}
