package cs2110;

import java.util.ArrayList;
import java.util.Iterator;

public class ListSet<T> implements Set<T> {

    /** Elements of this set
     *  Invariant: `data` is not null, no element of `data` is repeated.
     *  elements of `data` are not null
     */
    private ArrayList<T> data;

    private void assertInv() {
        assert this.data != null;
        for (int i = 0; i < this.data.size(); i++) {
            assert this.data.get(i) != null;
            for (int j = i + 1; j < this.data.size(); j++) {
                assert ! this.data.get(i).equals(data.get(j));
            }
        }
    }
    /** Constructs an empty set */
    public ListSet() {
        this.data = new ArrayList<>();
    }

    @Override
    public boolean add(T elem) {
        assertInv();
        boolean ret = false;
        if (!this.contains(elem)) {
            this.data.add(elem);
            ret = true;
        }
        assertInv();
        return ret;
    }

    @Override
    public boolean contains(T elem) {
        assertInv();
        assert elem != null;
        for (T member : this.data) {
            if (member.equals(elem)) {
                assertInv();
                return true;
            }
        }
        assertInv();
        return false;
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean remove(T elem) {
        assertInv();
        boolean ret = false;
        if (this.contains(elem)) {
            this.data.remove(elem);
            ret = true;
        }
        assertInv();
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    /**
     * Returns a new set containing the union of this set and `other`.
     */
    public ListSet<T> union(ListSet<T> other) {
        ListSet<T> u = new ListSet<>();
        for (T elem : data) {
            u.data.add(elem);
        }
        for (T elem : other) {
            if (!contains(elem)) {
                u.data.add(elem);
            }
        }
        return u;
    }

    /**
     * Returns a new set containing only the elements of this set that satisfy the given predicate.
     */
    public ListSet<T> restrict(Predicate<T> pred) {
        ListSet<T> subset = new ListSet<>();
        for (T elem : data) {
            if (pred.satisfiedBy(elem)) {
                subset.data.add(elem);
            }
        }
        return subset;
    }

    /**
     * Returns a new set containing the intersection of this set and `other`.
     */
    public ListSet<T> intersection(ListSet<T> other) {
        return restrict(other::contains);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator<T> it = iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(",");
            sb.append(it.next());
        }
        sb.append("}");
        return sb.toString();
    }
}
