package cs2110;

import java.util.Iterator;

/**
 * An implementation of the Set interface leveraging composition with a BST.
 */
public class TreeSet<T extends Comparable<T>> implements Set<T> {
    // Note: T must be Comparable so it can be stored in the BST field

    /**
     * The BST containing the elements of this set.
     */
    private final BST<T> tree;

    /**
     * Constructs a TreeSet with no elements.
     */
    public TreeSet() {
        tree = new BST<>();
    }

    @Override
    public boolean add(T elem) {
        if (contains(elem)) {
            return false;
        }
        tree.add(elem);
        return true;
    }

    @Override
    public boolean contains(T elem) {
        return tree.contains(elem);
    }

    @Override
    public int size() {
        return tree.size();
    }

    @Override
    public boolean remove(T elem) {
        if (!contains(elem)) {
            return false;
        }
        tree.remove(elem);
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return tree.iterator();
    }
}
