package cs2110;

/**
 * Represents a vertex in a graph labeled with a String.
 */
public interface Vertex<E extends Edge<?>> {

    /**
     * Returns this vertex's label.
     */
    String label();

    /**
     * Returns the degree of this vertex.
     */
    int degree();

    /**
     * Returns whether there is an edge with this vertex as its tail and with a vertex labeled
     * `headLabel` as its head.
     */
    boolean hasNeighbor(String headLabel);

    /**
     * Returns the edge connecting this vertex to the vertex labeled with `headLabel`. Requires
     * that `hasNeighbor(headLabel) == true`.
     */
    E edgeTo(String headLabel);

    /**
     * Returns an object supporting iteration over all the edges connecting this vertex to another
     * vertex in the graph. This vertex serves as the "tail" vertex for each such edge.
     */
    Iterable<E> outgoingEdges();
}
