package cs2110;

/**
 * Represents a mutable, directed, simple graph whose vertices are labeled by Strings.
 */
public interface Graph<V extends Vertex<?>, E extends Edge<V>> {

    /* ***********************************************************************
     * Query methods                                                         *
     * ***********************************************************************/

    /**
     * Return the number of vertices in this graph.
     */
    int vertexCount();

    /**
     * Return the number of edges in this graph.
     */
    int edgeCount();

    /**
     * Return whether there is a vertex with the given `label` in this graph.
     */
    boolean hasVertex(String label);

    /**
     * Returns the vertex with the given `label`. Requires that `hasVertex(label) == true`.
     */
    V getVertex(String label);

    /**
     * Return whether there is an edge with head labeled `headLabel` and tail labeled `tailLabel` in
     * this graph.
     */
    boolean hasEdge(String headLabel, String tailLabel);

    /**
     * Returns the edge from vertex `headLabel` to vertex `tailLabel`.
     * Requires that `hasEdge(headLabel, tailLabel) == true`.
     */
    E getEdge(String headLabel, String tailLabel);

    /* ***********************************************************************
     * Mutation methods                                                      *
     * ***********************************************************************/

    /**
     * Adds a vertex with the given `label` to this graph. Throws an 
     * `IllegalArgumentException` if there is already a vertex in the graph with 
     * this label.
     */
    void addVertex(String label);

    /**
     * Adds the given `edge` to this graph. Requires that its head and tail are vertices in this
     * graph that are not already connect with an edge.
     */
    void addEdge(E edge);

    /* ***********************************************************************
     * Iteration methods                                                     *
     * ***********************************************************************/

    /**
     * Return an object supporting iteration over all the vertices in this graph.
     */
    Iterable<V> vertices();

    /**
     * Return an object supporting iteration over all the edges in this graph.
     */
    Iterable<E> edges();
}
