package classdemo;

public class RaceConditionDemo {
    public static class SharedInt {
        int x = 0;
    }

    public static void incrementNTimes(SharedInt shared, int n) {
        for (int i = 0; i < n; i++) {
            shared.x++;
        }
    }

    public static void main(String[] args) throws InterruptedException {
        SharedInt shared = new SharedInt(); // shared mutable variable
        int numInc = 1000000;
        Thread t1 = new Thread(() -> incrementNTimes(shared, numInc));
        Thread t2 = new Thread(() -> incrementNTimes(shared, numInc));
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.out.println("Final value of shared.x: " + shared.x);
    }
}
