package classdemo;

import java.util.ArrayList;
import java.util.Arrays;

/** Demonstrates concurrent modification of an un-thread-safe ArrayList */
public class SharedStateDemo {

    /** Adds `value` to `nums` 5 times */
    public static void addFiveOf(ArrayList<Integer> nums, int value) {
        for (int i = 0; i < 5; i++) {
            nums.add(value);
            // Note: adding a 1 ms sleep here might expose race conditions more often
        }
    }

    /**
     * Repeatedly runs an experiment where two threads attempt to modify
     * an un-thread-safe ArrayList. Depending on the execution environment,
     * race conditions may affect the output more or less frequently.
     */
    public static void main(String[] args) throws InterruptedException {
        for (int i = 0; true; i++) {
            ArrayList<Integer> nums = new ArrayList<>();

            // make another thread to add 5 ones
            Thread other = new Thread(() -> addFiveOf(nums, 1));
            other.start();

            // in this thread, we'll add 5 twos
            addFiveOf(nums, 2);

            other.join(); // wait for all entries to be added

            System.out.println(i + ": " + Arrays.toString(nums.toArray()));
            Thread.sleep(100); // slow enough to see an anomaly
        }
    }
}
