package classdemo;

/** Simple thread code for playing with thread basics! */
public class ThreadDemo {

    /** Helper method to print information about a thread */
    public static void printCurrentThreadInfo() {
        Thread t = Thread.currentThread();
        System.out.println(t);
    }

    /** Two threads operating concurrently */
    public static void simpleDemo() {
        printCurrentThreadInfo();
        Thread t2 = new Thread(() -> demoThread(), "t2");
        t2.start();
    }

    /** Body of the runnable used for t2 in simpleDemo() */
    public static void demoThread() {
        printCurrentThreadInfo();
    }

    /** Demonstrates Thread.sleep() and responding to interruption
     * by simulating countdown to a rocket launch */
    public static void launch() {
        try {
            for (int i = 10; i > 0; i--) {
                System.out.print(i + "...");
                Thread.sleep(500);
            }
        } catch (InterruptedException ie) {
            // interruption is a polite request to terminate, so we return early
            System.out.println("LAUNCH CANCELED");
            return;
        }
        System.out.println("BLASTOFF");
    }

    /** Demonstrates what happens when we interrupt a sleeping thread
     * Throws InterruptedException if interrupted while sleeping */
    public static void interruptedLaunch() throws InterruptedException {
        Thread rocket = new Thread(() -> launch(), "rocket");
        rocket.start();
        Thread.sleep(3000);
        rocket.interrupt();
    }

    /** Demonstrates use of join to control sequencing of threads.
     * Throws InterruptedException if one of the threads being joined
     * received an interruption before it finished */
    public static void fourThreads() throws InterruptedException {
        printCurrentThreadInfo();
        Thread t2 = new Thread(() -> demoThread(), "t2");
        Thread t3 = new Thread(() -> demoThread(), "t3");
        Thread t4 = new Thread(() -> demoThread(), "t4");

        t2.start();
        t2.join();

        t3.start();
        t3.join();

        t4.start();
        t4.join();

        System.out.println("end multi thread demo");
    }

    /** Test bench for running the helper methods above */
    public static void main(String[] args) throws InterruptedException {
        //simpleDemo();
        //launch();
        //interruptedLaunch();
        fourThreads();
    }
}
