package lecturenotes;

import java.util.LinkedList;
import java.util.List;

public class MoreRaceConditions {

    public static class SharedInt {
        int x = 0;
    }

    public static void increment(SharedInt shared) {
        int xCurrent = shared.x;
        shared.x = xCurrent + 1;
    }

    public static void main(String[] args) throws InterruptedException {
        int nThreads = 16;
        int nIterations = 1000;

        // Create shared mutable variable
        SharedInt shared = new SharedInt();

        // Create threads and define their tasks
        List<Thread> threads = new LinkedList<>();

        for (int i = 0; i < nThreads; ++i) {
            // Task defined with lambda expression that _captures_ `shared`
            threads.add(new Thread(() -> {
                for (int k = 0; k < nIterations; ++k) {
                   increment(shared);
                }
            }));
        }

        // Start threads
        for (Thread t : threads) {
            t.start();
        }

        // Wait for all threads to finish
        for (Thread t : threads) {
            t.join();
        }

        System.out.println("Final value of shared.x: " + shared.x);
    }
}
