package lecturenotes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class SharedStateDemoWithSleep {

    public static void addOnes(ArrayList<Integer> nums) throws InterruptedException {
        Random rng = new Random();
        for (int i=0; i<5; i++) {
            nums.add(1);
            Thread.sleep(rng.nextInt(100));
            Thread.sleep(1);
        }
    }

    public static void main(String[] args) throws InterruptedException {
        ArrayList<Integer> nums = new ArrayList<>();

        Thread other = new Thread(() -> {
            try {
                addOnes(nums);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        other.start();

        Random rng = new Random();
        for (int i=0; i<5; i++) {
            nums.add(0);
            Thread.sleep(rng.nextInt(100));
            Thread.sleep(1);
        }
        other.join(); // wait for all entries to be added

        System.out.println(Arrays.toString(nums.toArray()));
    }
}
