package lecturenotes;

public class TwoThreadsDemo {
    public static void sayHello() throws InterruptedException {
        System.out.println("Hello from " + Thread.currentThread());
        Thread.sleep(100);
    }

    public static void main(String[] args) throws InterruptedException {
        System.out.println("Entering main() in " + Thread.currentThread());

        Thread other = new Thread(() -> {
            try {
                sayHello();
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, "other");
        // other.run(); // this will cause the hello message to be printed from the main thread
        other.start(); // this will cause the hello message to be printed from the other thread
        other.join();

        System.out.println("Exiting main()");
    }
}
