package classdemo;

import java.util.ArrayList;

public class DeadlockSolution2 {

    public static class SharedInt {
        int x;

        public SharedInt(int init) {
            x = init;
        }
    }

    /** Put thread to sleep for specified number of `millis`econds. */
    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException ignored) {}
    }

    public static void usePan(SharedInt numClean, SharedInt numDirty, int chefId) {
        synchronized (numClean) {
            System.out.printf("Chef %d grabs a clean pan and starts cooking.\n", chefId);
            numClean.x--;
            sleep((int)(Math.random()*100));

            synchronized (numDirty) {
                System.out.printf("Chef %d is done cooking.\n", chefId);
                numDirty.x++;
            }
        }
    }

    public static void cleanPan(SharedInt numClean, SharedInt numDirty, int dishwasherId) {

        synchronized (numClean) {
            synchronized (numDirty) {
                System.out.printf("Dishwasher %d starts cleaning a dirty pan.\n", dishwasherId);
                numDirty.x--;
                sleep((int) (Math.random() * 100));

                System.out.printf("Dishwasher %d is done cleaning.\n", dishwasherId);
                numClean.x++;
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        SharedInt numClean = new SharedInt(10);
        SharedInt numDirty = new SharedInt(10);

        System.out.printf("Kitchen opens with %d clean pans and %d dirty pans.\n", numClean.x, numDirty.x);

        ArrayList<Thread> threads = new ArrayList<>();
        for (int i=0; i<10; i++) {
            final int fi = i;
            threads.add(new Thread(() -> usePan(numClean, numDirty, fi))); // "chef" thread
            threads.add(new Thread(() -> cleanPan(numClean, numDirty, fi))); // "dishwasher" thread
        }

        for (Thread t : threads) {
            t.start();
        }

        for (Thread t : threads) {
            t.join();
        }

        System.out.println("Simulation Complete");
    }
}
