package classdemo;

public class KitchenSimulation {

    public static class SharedInt {

        int x;

        public SharedInt(int init) {
            x = init;
        }
    }

    /**
     * Put thread to sleep for specified number of `millis`econds.
     */
    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException ignored) {
        }
    }

    public static void simulateChef(SharedInt numClean, SharedInt numDirty) {
        for (int i = 0; i < 3; i++) {
            synchronized (numClean) {
                System.out.println("The chef grabs a clean pan and starts cooking.");
                numClean.x--;
                System.out.printf("There are %d clean pans remaining.\n", numClean.x);
            }
            sleep((int) (Math.random() * 100));
            synchronized (numDirty) {
                System.out.println("The chef is done cooking.");
                numDirty.x++;
                System.out.printf("There are now %d dirty pans.\n", numDirty.x);
            }
            sleep((int) (Math.random() * 100));
        }
    }

    public static void simulateDishwasher(SharedInt numClean, SharedInt numDirty) {
        for (int i = 0; i < 3; i++) {
            synchronized (numDirty) {
                System.out.println("The dishwasher grabs a dirty pan and starts cleaning.");
                numDirty.x--;
                System.out.printf("There are %d dirty pans remaining.\n", numDirty.x);
            }
            sleep((int) (Math.random() * 100));
            synchronized (numClean) {
                System.out.println("The dishwasher is done cleaning.");
                numClean.x++;
                System.out.printf("There are now %d clean pans.\n", numClean.x);
            }
            sleep((int) (Math.random() * 100));
        }
    }

    public static void main(String[] args) throws InterruptedException {
        SharedInt numClean = new SharedInt(2);
        SharedInt numDirty = new SharedInt(0);

        System.out.printf("The kitchen opens with %d clean pans and %d dirty pans.\n", numClean.x, numDirty.x);

        Thread chefThread = new Thread(() -> simulateChef(numClean, numDirty));
        Thread dishwasherThread = new Thread(() -> simulateDishwasher(numClean, numDirty));

        chefThread.start();
        dishwasherThread.start();

        chefThread.join();
        dishwasherThread.join();

        System.out.println("Simulation Complete");
    }
}
