package classdemo;

public class KitchenSimulationFinal {

    public static class SharedInt {

        int x;

        public SharedInt(int init) {
            x = init;
        }
    }

    /**
     * Put thread to sleep for specified number of `millis`econds.
     */
    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException ignored) {
        }
    }

    public static void simulateChef(SharedInt numClean, SharedInt numDirty)
            throws InterruptedException {
        for (int i = 0; i < 3; i++) {
            synchronized (numClean) {
                while (numClean.x == 0) {
                    numClean.wait();
                }
                System.out.println("The chef grabs a clean pan and starts cooking.");
                numClean.x--;
                numClean.notifyAll();
                System.out.printf("There are %d clean pans remaining.\n", numClean.x);
            }
            sleep((int) (Math.random() * 100));
            synchronized (numDirty) {
                System.out.println("The chef is done cooking.");
                numDirty.x++;
                numDirty.notifyAll();
                System.out.printf("There are now %d dirty pans.\n", numDirty.x);
            }
            sleep((int) (Math.random() * 100));
        }
    }

    public static void simulateDishwasher(SharedInt numClean, SharedInt numDirty)
            throws InterruptedException {
        for (int i = 0; i < 3; i++) {
            synchronized (numDirty) {
                while (numDirty.x == 0) {
                    numDirty.wait();
                }
                System.out.println("The dishwasher grabs a dirty pan and starts cleaning.");
                numDirty.x--;
                numDirty.notifyAll();
                System.out.printf("There are %d dirty pans remaining.\n", numDirty.x);
            }
            sleep((int) (Math.random() * 100));
            synchronized (numClean) {
                System.out.println("The dishwasher is done cleaning.");
                numClean.x++;
                numClean.notifyAll();
                System.out.printf("There are now %d clean pans.\n", numClean.x);
            }
            sleep((int) (Math.random() * 100));
        }
    }

    public static void main(String[] args) throws InterruptedException {
        SharedInt numClean = new SharedInt(2);
        SharedInt numDirty = new SharedInt(0);

        System.out.printf("The kitchen opens with %d clean pans and %d dirty pans.\n", numClean.x, numDirty.x);

        Thread chefThread = new Thread(() -> {
            try {
                simulateChef(numClean, numDirty);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
        Thread dishwasherThread = new Thread(() -> {
            try {
                simulateDishwasher(numClean, numDirty);
            } catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });

        chefThread.start();
        dishwasherThread.start();

        chefThread.join();
        dishwasherThread.join();

        System.out.println("Simulation Complete");
    }
}
