package classdemo;

public class SynchronizationDemo {
    public static class SharedInt {
        int x = 0;

        public void increment() {
            synchronized (this) {
                this.x++;
            }
        }
        public void decrement() {
            synchronized (this) {
                this.x--;
            }
        }
    }
    public static void incrementNTimes(SharedInt shared, int n) {
        for (int i = 0; i < n; i++) {
            shared.increment();
        }
    }
    public static void decrementNTimes(SharedInt shared, int n) {
        for (int i = 0; i < n; i++) {
            shared.decrement();
        }
    }
    public static void main(String[] args) throws InterruptedException {
        SharedInt shared = new SharedInt(); // shared mutable variable
        int numInc = 1000000;
        Thread t1 = new Thread(() -> incrementNTimes(shared, numInc));
        Thread t2 = new Thread(() -> decrementNTimes(shared, numInc));
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.out.println("Final value of shared.x: " + shared.x);
    }
}
