package lecturenotes;

import java.util.ArrayList;

public class DifferentLocksDemo {

    public static class SharedInt {
        int x = 0;
    }

    /** Put thread to sleep for specified number of `millis`econds. */
    public static void sleep(int millis) {
        try {
            Thread.sleep(millis);
        } catch (InterruptedException ignored) {}
    }

    public static void increment(SharedInt shared) {
        int currentX = shared.x;
        sleep((int)(Math.random()*10));
        shared.x = currentX + 1;
    }

    public static void decrement(SharedInt shared) {
        int currentX = shared.x;
        sleep((int)(Math.random()*10));
        shared.x = currentX - 1;
    }

    public static void main(String[] args) throws InterruptedException {
        SharedInt shared = new SharedInt(); // shared mutable variable

        ArrayList<Thread> threads = new ArrayList<>();

        Object incrementLock = new Object();
        Object decrementLock = new Object();

        for (int i=0; i<10; i++) {
            threads.add(new Thread(() -> { synchronized(incrementLock) { increment(shared); }}));
            threads.add(new Thread(() -> { synchronized(decrementLock) { decrement(shared); }}));
        }

        for (Thread t : threads) {
            t.start();
        }

        for (Thread t : threads) {
            t.join();
        }

        System.out.println("Final value of shared.x: " + shared.x);
    }
}
