package cs2110;

public class LoopInvariants {

    /**
     * Reassigns all negative entries of the `readings` array to 0.
     */
    static void cleanData(double[] readings) {
        int i = readings.length - 1;
        while (i >= 0) {
            if (readings[i] < 0) {
                readings[i] = 0;
            }
            i--;
        }
    }

    /**
     * Returns whether the entries of `nums` form a *mountain*, meaning there is some index `i` such
     * that `nums[..i]` is non-decreasing and `nums[i..]` is non-increasing. Requires that
     * `nums.length > 0`.
     */
    static boolean isMountain(int[] nums) {
        assert nums.length > 0; // defensive programming

        int j = 1;
        boolean goingDown = false;
        /*
         * Loop invariant: `nums[0..j)` is mountainous, consisting of a non-decreasing section and
         * potentially followed by a non-increasing section iff `goingDown == true`. `nums[j..)` is
         * unknown.
         */
        while (j < nums.length) {
            if (goingDown && nums[j] > nums[j - 1]) {
                return false;
            } else if (nums[j] < nums[j - 1]) {
                goingDown = true;
            }
            j++;
        }
        return true;
    }

    /**
     * Swaps the entries `nums[x]` and `nums[y]`. Requires that `0 <= x < nums.length` and `0 <= y <
     * nums.length`.
     */
    static void swap(int[] nums, int x, int y) {
        int temp = nums[x];
        nums[x] = nums[y];
        nums[y] = temp;
    }

    /**
     * Rearranges the elements of `nums` about the given `pivot` so that `nums[..i) < pivot`,
     * `nums[i..j) == pivot` and `nums[j..] > pivot` for some indices `i,j`. Requires that
     * `nums.length > 0`.
     */
    static void partition3Way(int[] nums, int pivot) {
        assert nums.length > 0; // defensive programming

        int i = 0;
        int k = nums.length;
        int j = nums.length;

        /*
         * Loop invariant: nums[..i) < pivot, nums[k...j) == pivot, nums[j...] > pivot
         */
        while (i < k) {
            if (nums[i] < pivot) {
                i++; // expand the less than region
            } else if (nums[i] == pivot) {
                swap(nums, i, k - 1); // swap nums[i] into the equals region
                k--; // expand the equals region
            } else { // nums[i] > pivot
                swap(nums, i, k - 1); // swap nums[i] to the front of the equals region
                swap(nums, k - 1, j - 1); // swap front of equals region to front of < region

                k--; // expand the equals region
                j--; // expand the > region
            }
        }
    }
}
