package cs2110;

public class Runtime {

    /**
     * Rearranges the elements of `a` so that all even elements appear before all odd elements.
     * Returns the index of the first odd element, or returns `a.length` if all elements are even.
     */
    static int paritySplit(int[] a) {
        int i = 0;
        int j = a.length;
        /* Loop invariant: `a[..i)` is even, `a[j..]` is odd */
        while (i < j) {
            if (a[i] % 2 == 0) {
                i++;
            } else {
                swap(a, i, j - 1);
                j--;
            }
        }
        return j;
    }

    /**
     * Swaps the entries `a[i]` and `a[j]`. Requires that `0 <= i < a.length` and `0 <= j <
     * a.length`.
     */
    static void swap(int[] a, int i, int j) {
        int temp = a[i];
        a[i] = a[j];
        a[j] = temp;
    }

    /**
     * Returns whether `a` contains duplicate entries, distinct indices `i != j` with `a[i] ==
     * a[j]`.
     */
    static boolean hasDuplicates(int[] a) {
        for (int i = a.length - 1; i >= 0; i--) {
            for (int j = 0; j < i; j++) {
                if (a[i] == a[j]) {
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) {

        int[] sizes = {1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000};

        for (int N : sizes) {
            int[] a = new int[N];
            for (int i = 0; i < N; i++) {
                a[i] = i;
            }

            long start = System.nanoTime();
            paritySplit(a);
            long end = System.nanoTime();
            System.out.println("N=" + N + ": paritySplit() ran in " + (end - start) / 1e6 + " ms.");

        }

        // TODO: Play around with this simulation code to test out other input sizes, other values
        //  in the array, other methods, etc.

    }

}
