package cs2110;

import java.util.Arrays;

/**
 * A class containing examples of recursive methods
 */
public class Recursion {

    /**
     * Returns `n!`, the product of all positive integers less than or
     * equal to `n`. Requires `0 <= n <= 12` (to prevent overflow).
     */
    static int factorial(int n) {
        assert 0 <= n && n <= 12; // defensive programming
        if (n <= 1) {
            return 1;
        }
        int f = factorial(n - 1);
        return f * n;
    }

//    // A streamlined implementation using Java's conditional operator
//    static int factorial(int n) {
//        assert 0 <= n && n <= 12; // defensive programming
//        return n <= 1 ? 1 : (n * factorial(n - 1));
//    }

    /**
     * Returns the maximum value in array `nums`. Requires that `nums` is non-empty.
     */
    static double maxValueInefficient(double[] nums) {
        /*
         * This version of the method uses expensive array copying to achieve recursion with
         * the original method signature. It has both O(N^2) space and time complexity,
         * significantly worse than the straightforward iterative implementation.
         */
        if (nums.length == 1) {
            return nums[0];
        }
        double[] rest = Arrays.copyOfRange(nums, 1, nums.length);
        return Math.max(nums[0], maxValueInefficient(rest));
    }

    /**
     * Returns the maximum value in array `nums`. Requires that `nums` is non-empty.
     */
    static double maxValue(double[] nums) {
        return maxValueRecursive(nums, 0);
    }

    /**
     * Returns the maximum value in array `nums[begin..]`. Requires that
     * `0 <= begin < nums.length`.
     */
    static double maxValueRecursive(double[] nums, int begin) {
        if (begin == nums.length - 1) {
            return nums[begin];
        }
        double m = maxValueRecursive(nums, begin + 1);
        return Math.max(nums[begin], m);
    }

    /**
     * Returns true if there is a subset of entries from `coins` whose sum is equal to `total`,
     * otherwise returns `false`.
     */
    static boolean canMakeChange(int total, int[] coins) {
        return canMakeChangeRecursive(total, coins, 0);
    }

    /**
     * Returns true if there is a subset of entries from `coins` beginning at index `begin` whose
     * sum is equal to `total`, otherwise returns `false`.
     */
    static boolean canMakeChangeRecursive(int total, int[] coins, int begin) {
        if (begin == coins.length) {
            return total == 0;
        }
        return canMakeChangeRecursive(total, coins, begin + 1) // don't use coins[begin]
                || canMakeChangeRecursive(total - coins[begin], coins, begin + 1); // use coins[begin]
    }
}
