package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class ChangeTest {

    @DisplayName("WHEN there is a subset of `coins` summing to `total`, THEN `canMakeChange()` "
            + "returns `true`.")
    @Test
    void testChangeTrue() {
        assertTrue(Recursion.canMakeChange(1, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(10, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(25, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(11, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(20, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(26, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(45, new int[]{1, 10, 10, 25, 25}));
        assertTrue(Recursion.canMakeChange(71, new int[]{1, 10, 10, 25, 25}));
    }

    @DisplayName("WHEN there is no subset of `coins` summing to `total`, THEN `canMakeChange()` "
            + "returns `false`.")
    @Test
    void testChangeFalse() {
        assertFalse(Recursion.canMakeChange(2, new int[]{1, 10, 10, 25, 25}));
        assertFalse(Recursion.canMakeChange(5, new int[]{1, 10, 10, 25, 25}));
        assertFalse(Recursion.canMakeChange(31, new int[]{1, 10, 10, 25, 25}));
        assertFalse(Recursion.canMakeChange(40, new int[]{1, 10, 10, 25, 25}));
        assertFalse(Recursion.canMakeChange(55, new int[]{1, 10, 10, 25, 25}));
    }

    @DisplayName("WHEN `total` is 0, THEN `canMakeChange()` returns true regardless of the "
            + "contents of `coins`.")
    @Test
    void testChangeZero() {
        assertTrue(Recursion.canMakeChange(0, new int[]{1, 5, 10}));
        assertTrue(Recursion.canMakeChange(0, new int[]{10, 25, 25, 25}));
        assertTrue(Recursion.canMakeChange(0, new int[]{1}));
    }

    @DisplayName("WHEN `coins` is empty, THEN `canMakeChange()` only returns true if `total` is 0.")
    @Test
    void testChangeEmpty() {
        assertTrue(Recursion.canMakeChange(0, new int[0]));
        assertFalse(Recursion.canMakeChange(1, new int[0]));
        assertFalse(Recursion.canMakeChange(12, new int[0]));
    }
}
