package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class MaxTest {

    @DisplayName("WHEN we compute the maximum value of an array with one element, THEN "
            + "this element is returned.")
    @Test
    void testMaxOfOne() {
        assertEquals(1.3, Recursion.maxValue(new double[]{1.3}));
    }

    @DisplayName("WHEN we compute the maximum value of an array with two element, THEN "
            + "the larger element is returned, regardless of its position.")
    @Test
    void testMaxOfTwo() {
        assertEquals(2.6, Recursion.maxValue(new double[]{2.6, 1.3})); // max is first
        assertEquals(2.6, Recursion.maxValue(new double[]{1.3, 2.6})); // max is second
    }

    @DisplayName("WHEN we compute the maximum value of an array with many distinct elements, THEN "
            + "the correct value is returned.")
    @Test
    void testMaxOfManyDistinct() {
        assertEquals(10, Recursion.maxValue(new double[]{1,4,6,3,10,7,2,5,9,8}));
    }

    @DisplayName("WHEN we compute the maximum value of an array in which the maximum value appears "
            + "multiple times, THEN the correct value is returned.")
    @Test
    void testMaxMultiple() {
        assertEquals(4, Recursion.maxValue(new double[]{1,1,2,2,3,3,4,4}));
    }

}
