package cs2110;

public class Sorting {

    /**
     * Sorts the entries of `a` using the insertion sort algorithm.
     */
    static void insertionSort(int[] a) {
        /* Loop invariant: a[..i) is sorted, a[i..] are unchanged. */
        for (int i = 0; i < a.length; i++) {
            insert(a, i);
        }
    }

    /**
     * Inserts entry `a[i]` into its sorted position in `a[..i)` such that `a[..i]` contains the
     * same entries in sorted order. Requires that `0 <= i < a.length` and `a[..i)` is sorted.
     */
    static void insert(int[] a, int i) {
        assert 0 <= i && i < a.length; // defensive programming
        int j = i;
        /* Loop invariant: a[..j) and a[j..i] are both sorted. */
        while (j > 0 && a[j - 1] > a[j]) {
            swap(a, j - 1, j);
            j--;
        }
    }

    /**
     * Swaps the entries `a[x]` and `a[y]`. Requires that `0 <= x < a.length` and `0 <= y <
     * a.length`.
     */
    static void swap(int[] a, int x, int y) {
        int temp = a[x];
        a[x] = a[y];
        a[y] = temp;
    }

    /**
     * Sorts the entries of `a` using the merge sort algorithm.
     */
    static void mergeSort(int[] a) {
        int[] work = new int[a.length / 2];
        mergeSortRecursive(a, 0, a.length, work);
    }

    /**
     * Recursively sorts the entries of `a[begin..end)` using the merge sort algorithm.
     */
    static void mergeSortRecursive(int[] a, int begin, int end, int[] work) {
        if (end - begin <= 1) {
            return;
        }
        int mid = begin + (end - begin) / 2;
        mergeSortRecursive(a, begin, mid, work);
        mergeSortRecursive(a, mid, end, work);
        merge(a, begin, mid, end, work);
    }

    /**
     * Merges the sorted ranges `a[begin..mid)` and `a[mid..end)` so that `a[begin..end)` contains
     * the same entries in sorted order. Requires that `a[begin..mid)` and `a[mid..end)` are
     * sorted.
     */
    static void merge(int[] a, int begin, int mid, int end, int[] work) {
        System.arraycopy(a, begin, work, 0, mid - begin);
        int i = 0; // index in work array
        int j = mid; // index in right input
        int k = begin; // index in output

        while (k < j) {
            if (j == end || work[i] <= a[j]) {
                a[k] = work[i];
                i++;
            } else {
                a[k] = a[j];
                j++;
            }
            k++; // advance output index
        }
    }

    /**
     * Sorts the entries of `a` using the quicksort algorithm and a naive pivot selection.
     */
    static void quicksort(int[] a) {
        quicksortRecursive(a, 0, a.length);
    }

    /**
     * Recursively sorts the entries of `a[begin..end)` using the quicksort algorithm
     * and a naive pivot selection.
     */
    static void quicksortRecursive(int[] a, int begin, int end) {
        if (end - begin <= 1) {
            return; // base case
        }
        int pivotIndex = begin; // TODO: replace with a better selection rule to improve performance
        int i = partition(a, begin, end, pivotIndex);
        quicksortRecursive(a, begin, i);
        quicksortRecursive(a, i + 1, end);
    }

    /**
     * Rearranges the elements of `a[begin..end)` about pivot `a[pivotIndex]`. Returns
     * index `i` such that `a[begin..i) < pivot` and `a[i..end) >= pivot`.
     * Requires that `0 <= begin < end <= a.length` and `begin <= pivotIndex < end`.
     */
    static int partition(int[] a, int begin, int end, int pivotIndex) {
        assert 0 <= begin && begin < end && end <= a.length; // defensive programming
        assert begin <= pivotIndex && pivotIndex < end;

        swap(a, begin, pivotIndex); // move pivot to begin
        int i = begin;
        int j = end - 1;
        /* Loop invariant: `a[i] = pivot`, `a[..i) < pivot`, `a(j..) >= pivot`. */
        while (i < j) {
            if (a[i + 1] < a[i]) {
                swap(a, i, i + 1);
                i++;
            } else {
                swap(a, i + 1, j);
                j--;
            }
        }
        return i;
    }
}
