package cs2110;

public class Fraction {

    /**
     * Numerator of this fraction.
     * <p>
     * Must be in reduced form with the denominator.
     */
    private int numerator;
    /**
     * Denominator of this fraction.
     * <p>
     * Must be in reduced form with the numerator. Must be strictly positive.
     */
    private int denominator;

    /**
     * Create a new fraction. Requires the denominator not be zero.
     */
    public Fraction(int numerator, int denominator) {
        assert denominator != 0;
        this.numerator = numerator;
        this.denominator = denominator;
        reduceSelf();
        assert invariantSatisfied();
    }

    /**
     * Restores the class invariant by reducing the numerator and denominator, and ensuring the
     * denominator is non-negative.
     */
    private void reduceSelf() {
        int gcd = IntHelper.gcd(numerator, denominator);
        this.numerator = numerator / gcd;
        this.denominator = denominator / gcd;

        if (this.denominator < 0) {
            this.numerator = -1 * numerator;
            this.denominator = -1 * denominator;
        }
    }

    /**
     * Get this fraction in its reduced form as a string, of the form numerator/denominator.
     * <p>
     * If this fraction represents an integer, the denominator will be 1.
     */
    public String getReducedForm() {
        return ((numerator) + "/" + (denominator));
    }

    /**
     * Doubles this fraction, mutating it to be twice its original value.
     */
    public void doubleMe() {
        this.numerator = 2 * this.numerator;
        reduceSelf();
        assert invariantSatisfied();
    }

    /**
     * Returns true if and only if the class invariant is satisfied.
     */
    private boolean invariantSatisfied() {
        if (denominator <= 0) {
            return false;
        }
        return IntHelper.gcd(denominator, numerator) == 1;
    }
}
