package cs2110;

import static org.junit.jupiter.api.Assertions.*;

import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public class TicTacToeTest {

    @DisplayName("WHEN a new Tic-tac-toe game is created, THEN the current player "
            + "(who gets the first move) is X.")
    @Test
    void testFirstPlayer() {
        TicTacToe ttt = new TicTacToe();
        assertEquals('X', ttt.currentPlayer());
    }

    @DisplayName("WHEN a new Tic-tac-toe game is created, THEN the game is not over "
            + "before the first move is made.")
    @Test
    void testGameNotOverAtStart() {
        TicTacToe ttt = new TicTacToe();
        assertFalse(ttt.gameOver());
    }

    @DisplayName("WHEN a new Tic-tac-toe game is created, THEN all of its cells are initially blank.")
    @Test
    void testGridStartsBlank() {
        TicTacToe ttt = new TicTacToe();
        assertEquals(' ', ttt.contentsOf(0,0));
        assertEquals(' ', ttt.contentsOf(0,1));
        assertEquals(' ', ttt.contentsOf(0,2));
        assertEquals(' ', ttt.contentsOf(1,0));
        assertEquals(' ', ttt.contentsOf(1,1));
        assertEquals(' ', ttt.contentsOf(1,2));
        assertEquals(' ', ttt.contentsOf(2,0));
        assertEquals(' ', ttt.contentsOf(2,1));
        assertEquals(' ', ttt.contentsOf(2,2));
    }

    @DisplayName("WHEN the first move is made in a Tic-tac-toe game, THEN an 'X' is placed in the "
            + "correct square.")
    @Test
    void testFirstMoveRecorded() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        assertEquals('X', ttt.contentsOf(0,0));
        // check that other squares are empty
        assertEquals(' ', ttt.contentsOf(0,1));
        assertEquals(' ', ttt.contentsOf(0,2));
        assertEquals(' ', ttt.contentsOf(1,0));
        assertEquals(' ', ttt.contentsOf(1,1));
        assertEquals(' ', ttt.contentsOf(1,2));
        assertEquals(' ', ttt.contentsOf(2,0));
        assertEquals(' ', ttt.contentsOf(2,1));
        assertEquals(' ', ttt.contentsOf(2,2));

        // also check other possible first moves
        ttt = new TicTacToe();
        ttt.processMove(0,1);
        assertEquals('X', ttt.contentsOf(0,1));

        ttt = new TicTacToe();
        ttt.processMove(0,2);
        assertEquals('X', ttt.contentsOf(0,2));

        ttt = new TicTacToe();
        ttt.processMove(1,0);
        assertEquals('X', ttt.contentsOf(1,0));

        ttt = new TicTacToe();
        ttt.processMove(1,1);
        assertEquals('X', ttt.contentsOf(1,1));

        ttt = new TicTacToe();
        ttt.processMove(1,2);
        assertEquals('X', ttt.contentsOf(1,2));

        ttt = new TicTacToe();
        ttt.processMove(2,0);
        assertEquals('X', ttt.contentsOf(2,0));

        ttt = new TicTacToe();
        ttt.processMove(2,1);
        assertEquals('X', ttt.contentsOf(2,1));

        ttt = new TicTacToe();
        ttt.processMove(2,2);
        assertEquals('X', ttt.contentsOf(2,2));
    }

    @DisplayName("WHEN the first move is made in a Tic-tac-toe game, THEN the current player "
            + "switches to 'O'.")
    @Test
    void testPlayerSwitchAfterFirstMove() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(1,1);
        assertEquals('O', ttt.currentPlayer());
    }

    @DisplayName("WHEN the first move is made in a Tic-tac-toe game, THEN the game is is still "
            + "not over.")
    @Test
    void testFirstMoveGameNotOver() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(1,1);
        assertFalse(ttt.gameOver());
    }

    @DisplayName("WHEN the second move is made in a Tic-tac-toe game, THEN both moves are correctly "
            + "recorded on the board.")
    @Test
    void testTwoMovesRecorded() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        ttt.processMove(1,1);
        assertEquals('X', ttt.contentsOf(0,0));
        assertEquals(' ', ttt.contentsOf(0,1));
        assertEquals(' ', ttt.contentsOf(0,2));
        assertEquals(' ', ttt.contentsOf(1,0));
        assertEquals('O', ttt.contentsOf(1,1));
        assertEquals(' ', ttt.contentsOf(1,2));
        assertEquals(' ', ttt.contentsOf(2,0));
        assertEquals(' ', ttt.contentsOf(2,1));
        assertEquals(' ', ttt.contentsOf(2,2));
    }

    @DisplayName("WHEN the second move is made in a Tic-tac-toe game, THEN the current player "
            + "switches back to 'X'.")
    @Test
    void testPlayerSwitchAfterSecondMove() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        ttt.processMove(1,1);
        assertEquals('X', ttt.currentPlayer());
    }

    @DisplayName("WHEN the second move is made in a Tic-tac-toe game, THEN the game is is still "
            + "not over.")
    @Test
    void testSecondMoveGameNotOver() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        ttt.processMove(1,1);
        assertFalse(ttt.gameOver());
    }

    @DisplayName("WHEN a sequence of moves results in a win for player 'X', THEN the game is over.")
    @Test
    void testXWinsGameOver() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        assertFalse(ttt.gameOver()); // make sure a winner wasn't reported early
        ttt.processMove(1,0);
        assertFalse(ttt.gameOver());
        ttt.processMove(0,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(1,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(0,2);
        assertTrue(ttt.gameOver());
    }

    @DisplayName("WHEN a sequence of moves results in a win for player 'X', THEN they are reported "
            + "as the `winner()`.")
    @Test
    void testXReportedWinner() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        ttt.processMove(1,0);
        ttt.processMove(0,1);
        ttt.processMove(1,1);
        ttt.processMove(0,2);
        assertEquals('X', ttt.winner());
    }

    @DisplayName("WHEN a sequence of moves results in a win for player 'O', THEN the game is over.")
    @Test
    void testOWinsGameOver() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        assertFalse(ttt.gameOver()); // make sure a winner wasn't reported early
        ttt.processMove(1,0);
        assertFalse(ttt.gameOver());
        ttt.processMove(0,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(1,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(2,0);
        assertFalse(ttt.gameOver());
        ttt.processMove(1,2);
        assertTrue(ttt.gameOver());
    }

    @DisplayName("WHEN a sequence of moves results in a win for player 'O', THEN they are reported "
            + "as the `winner()`.")
    @Test
    void testOReportedWinner() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        ttt.processMove(1,0);
        ttt.processMove(0,1);
        ttt.processMove(1,1);
        ttt.processMove(2,0);
        ttt.processMove(1,2);
        assertEquals('O', ttt.winner());
    }

    @DisplayName("WHEN a sequence of moves fills the board without a winner, THEN the game is over.")
    @Test
    void testTieGameOver() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        assertFalse(ttt.gameOver()); // make sure a winner wasn't reported early
        ttt.processMove(1,0);
        assertFalse(ttt.gameOver());
        ttt.processMove(0,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(1,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(1,2);
        assertFalse(ttt.gameOver());
        ttt.processMove(0,2);
        assertFalse(ttt.gameOver());
        ttt.processMove(2,0);
        assertFalse(ttt.gameOver());
        ttt.processMove(2,1);
        assertFalse(ttt.gameOver());
        ttt.processMove(2,2);
        assertTrue(ttt.gameOver());
    }

    @DisplayName("WHEN a sequence of moves results in a win for player 'O', THEN they are reported "
            + "as the `winner()`.")
    @Test
    void testReportTie() {
        TicTacToe ttt = new TicTacToe();
        ttt.processMove(0,0);
        ttt.processMove(1,0);
        ttt.processMove(0,1);
        ttt.processMove(1,1);
        ttt.processMove(1,2);
        ttt.processMove(0,2);
        ttt.processMove(2,0);
        ttt.processMove(2,1);
        ttt.processMove(2,2);
        assertEquals('T', ttt.winner());
    }

}
