package cs2110;

public class FinanceSimulation {

    public static void main(String[] args) {
        // The following initialization does not work. `Account` is an interface, it promises
        // behaviors, but it doesn't offer a blueprint for constructing objects.
        // Account checking = new Account();

        Account checking = createAccount("checking", "Matt's Checking", 13000);
        Account savings = createAccount("savings", "Matt's Savings", 230000);

        checking.depositFunds(4000, "Check from John");
        checking.transferFunds(savings, 10000);

        // a user could potentially have many more accounts of many different types, so we'll
        // collect them all in an array to process
        Account[] accounts = {checking, savings};
        for (int i = 0; i < accounts.length; i++) {
            System.out.println(accounts[i].name());  // dynamic dispatch
            System.out.println(accounts[i].transactionReport()); // dynamic dispatch
        }

        // // Note: The following code will not compile because of a compile-time reference rule
        // // violation. `Account`s do not declare an `interestRate()` method.
        // savings = new SavingsAccount("Savings", 230000, 3.0);
        // System.out.println("Interest Rate: " + savings.interestRate() + "%");

        // We can use a cast to access the `interestRate()` method.
        // System.out.println("Interest Rate: " + ((SavingsAccount)savings).interestRate() + "%");
    }

    /**
     * A *factory method* to create a new account of the given `type` with the given `name` and
     * `balance`. SavingsAccounts have a default interest rate of 3.0%. Requires that `type` is
     * either "checking" or "savings".
     */
    public static Account createAccount(String type, String name, int balance) {
        if (type.equals("checking")) {
            return new CheckingAccount(name, balance);
        } else { // type.equals("savings")
            return new SavingsAccount(name, balance, 3.0);
        }
        // this factory method leverages the return type subtype substitution rule to achieve
        // subtype polymorphism.
    }
}