package cs2110;

/**
 * Models a savings account in our personal finance app.
 */
public class SavingsAccount extends Account {

    /**
     * The current (nominal) APR of this account.
     */
    private double rate;

    /**
     * Constructs a savings account with the given `name`, initial `balance`, and interest `rate`.
     */
    public SavingsAccount(String name, int balance, double rate) {
        super(name, balance);
        this.rate = rate;
    }

    /**
     * Returns the current (nominal) APR of this account.
     */
    public double interestRate() {
        return this.rate;
    }

    /**
     * Adds the monthly interest payment to the account balance.
     */
    @Override
    protected void closeOutMonth() {
        int interestAmount = (int) (this.balance() * this.rate / (12 * 100));
        this.depositFunds(interestAmount, "Monthly interest @" + this.rate + "%");
    }
}
