package cs2110;

/**
 * Demonstrates how we can use a record class to simplify our Point implementation
 */
public class PointRecord {

    /**
     * An immutable class representing a point in the 2D coordinate plane with `double` coordinates.
     */
    public record Point(double x, double y) {

        /** Returns a String representation of this Point, of the form "Point (x,y)". */
        @Override
        public String toString() {
            return "Point (" + this.x + "," + this.y + ")";
        }

        /**
         * Returns the distance between this point and the given `other` point.
         */
        public double distanceTo(Point other) {
            return Math.sqrt(Math.pow(this.x - other.x, 2) + Math.pow(this.y - other.y, 2));
        }

        /**
         * Reflects this point over the line y = `m`x + `b` for the given slope `m` and y-intercept
         * `b`.
         */
        public Point reflectOver(double m, double b) {
            double newx = this.x - 2 * b * m + 2 * m * this.y - this.x * m * m;
            double newy = 2 * this.x * m + 2 * b + m * m * this.y - this.y;
            double d = 1 + m * m;
            return new Point(newx / d, newy / d);
        }
    }

    public static void main(String[] args) {
        Point p1 = new Point(0.0, 3.0);
        Point p2 = new Point(4.0, 1.0);
        Point p3 = p1.reflectOver(2.0, -2.0);
        System.out.println("p2: " + p2);
        System.out.println("p3: " + p3);
        System.out.println("==: " + (p2 == p3)); // we don't have equality of reference
        System.out.println("equals(): " + p2.equals(p3)); // we do have equality of state
    }
}
